package gov.va.vamf.scheduling.direct.web;

import com.agilex.healthcare.utility.XSSValidator;
import gov.va.vamf.scheduling.direct.utils.XSSSanitizer;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XSSRequestFilter implements ContainerRequestFilter {
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {

        validateParamsForXSS(requestContext.getUriInfo().getPathParameters());
        validateParamsForXSS(requestContext.getHeaders());
        validateParamsForXSS(requestContext.getCookies());

    }

    private void validateParamsForXSS( Map<String,Cookie> parameters ) {

        for( Map.Entry<String,Cookie> cookieEntry : parameters.entrySet() )
        {
            Cookie cookie = cookieEntry.getValue();
            String domain = cookie.getDomain();
            String name = cookie.getName();
            String path = cookie.getPath();
            String value = cookie.getValue();

            if( XSSValidator.hasXSSInjection(domain) || XSSValidator.hasXSSInjection(name)
                    || XSSValidator.hasXSSInjection(path) || XSSValidator.hasXSSInjection(value)) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            } else {
                domain = XSSSanitizer.sanitize(domain);
                name = XSSSanitizer.sanitize(name);
                path = XSSSanitizer.sanitize(path);
                value = XSSSanitizer.sanitize(value);
            }

            Cookie sanitizedCookie = new Cookie(name,value,path,domain,cookie.getVersion());
            parameters.put(cookieEntry.getKey(),sanitizedCookie);

        }

    }

    private void validateParamsForXSS( MultivaluedMap<String, String> parameters )
    {

        for( Map.Entry<String, List<String>> params : parameters.entrySet() )
        {
            List<String> values = params.getValue();
            List<String> valuesCopy = new ArrayList<String>(values);
            values.removeAll(values);

            for( String value : valuesCopy )
            {
                if(XSSValidator.hasXSSInjection(value)){
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                } else {
                    values.add(XSSSanitizer.sanitize(value));
                }
            }
        }
    }
}
